<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl wwmode msxsl wwlinks wwfiles wwdoc wwsplits wwtoc wwproject wwpage wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:key name="wwpage-files-by-path" match="wwpage:File" use="@path" />
 <xsl:key name="wwpage-conditions-by-name" match="wwpage:Condition" use="@name" />


 <!-- wwmode:pagetemplate-files -->
 <!--                           -->

 <xsl:template match="/" mode="wwmode:pagetemplate-files">
  <!-- Locate 'copy-relative-to-output' action attributes -->
  <!--                                                    -->
  <xsl:variable name="VarPageTemplateFilesAsXML">
   <xsl:for-each select="//*[@wwpage:*]">
    <xsl:variable name="VarNode" select="." />

    <xsl:for-each select="$VarNode/@*[starts-with(name(), 'wwpage:attribute-')]">
     <xsl:variable name="VarActionAttribute" select="." />
     <xsl:if test="$VarActionAttribute = 'copy-relative-to-output'">
      <!-- Report file -->
      <!--             -->
      <xsl:variable name="VarAttributeName" select="substring-after(name($VarActionAttribute), 'wwpage:attribute-')" />
      <xsl:variable name="VarAttribute" select="$VarNode/@*[name() = $VarAttributeName][1]" />
      <xsl:for-each select="$VarAttribute">
       <wwpage:File path="{$VarAttribute}" />
      </xsl:for-each>
     </xsl:if>
    </xsl:for-each>
   </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="VarPageTemplateFiles" select="msxsl:node-set($VarPageTemplateFilesAsXML)" />

  <!-- Eliminate duplicates -->
  <!--                      -->
  <xsl:for-each select="$VarPageTemplateFiles/wwpage:File">
   <xsl:variable name="VarPageTemplateFile" select="." />

   <xsl:variable name="VarPageTemplateFilesWithPath" select="key('wwpage-files-by-path', $VarPageTemplateFile/@path)" />
   <xsl:if test="count($VarPageTemplateFilesWithPath[1] | $VarPageTemplateFile) = 1">
    <xsl:copy-of select="$VarPageTemplateFile" />
   </xsl:if>
  </xsl:for-each>
 </xsl:template>


 <xsl:template match="*" mode="wwmode:pagetemplate-files">
  <!-- Ignore -->
  <!--        -->
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:pagetemplate-files">
  <!-- Ignore -->
  <!--        -->
 </xsl:template>


 <!-- wwmode:pagetemplate-include-files -->
 <!--                                   -->

 <xsl:template match="/" mode="wwmode:pagetemplate-include-files">
  <xsl:param name="ParamPageTemplateURI" />

  <!-- Page Template Directory URI -->
  <!--                             -->
  <xsl:variable name="VarPageTemplateDirectoryURI" select="wwuri:MakeAbsolute($ParamPageTemplateURI, '..')" />

  <!-- Locate 'content-from-file' and 'replace-from-file' attributes -->
  <!--                                                               -->
  <xsl:variable name="VarPageTemplateFilesAsXML">
   <xsl:for-each select="//*[@wwpage:*]">
    <xsl:variable name="VarNode" select="." />

    <!-- Include relative URI -->
    <!--                      -->
    <xsl:variable name="VarIncludeRelativeURI">
     <xsl:choose>
      <xsl:when test="string-length($VarNode/wwpage:replace-from-file) &gt; 0">
       <xsl:value-of select="$VarNode/@wwpage:replace-from-file" />
      </xsl:when>

      <xsl:when test="string-length($VarNode/wwpage:content-from-file) &gt; 0">
       <xsl:value-of select="$VarNode/@wwpage:content-from-file" />
      </xsl:when>

      <xsl:otherwise>
       <!-- Nothing! -->
       <!--          -->
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>

    <!-- Include relative URI defined? -->
    <!--                               -->
    <xsl:if test="string-length($VarIncludeRelativeURI) &gt; 0">
     <!-- Report file -->
     <!--             -->
     <xsl:variable name="VarAbsoluteURI" select="wwuri:MakeAbsolute($VarPageTemplateDirectoryURI, $VarIncludeRelativeURI)" />
     <xsl:variable name="VarAbsolutePath" select="wwuri:AsFilePath($VarAbsoluteURI)" />
     <wwpage:File path="{$VarAbsolutePath}" />
    </xsl:if>
   </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="VarPageTemplateFiles" select="msxsl:node-set($VarPageTemplateFilesAsXML)" />

  <!-- Eliminate duplicates -->
  <!--                      -->
  <xsl:for-each select="$VarPageTemplateFiles/wwpage:File">
   <xsl:variable name="VarPageTemplateFile" select="." />

   <xsl:variable name="VarPageTemplateFilesWithPath" select="key('wwpage-files-by-path', $VarPageTemplateFile/@path)" />
   <xsl:if test="count($VarPageTemplateFilesWithPath[1] | $VarPageTemplateFile) = 1">
    <xsl:copy-of select="$VarPageTemplateFile" />
   </xsl:if>
  </xsl:for-each>
 </xsl:template>


 <xsl:template match="*" mode="wwmode:pagetemplate-include-files">
  <xsl:param name="ParamPageTemplateURI" />

  <!-- Ignore -->
  <!--        -->
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:pagetemplate-include-files">
  <xsl:param name="ParamPageTemplateURI" />

  <!-- Ignore -->
  <!--        -->
 </xsl:template>


 <!-- wwmode:pagetemplate-copynodes -->
 <!--                               -->

 <xsl:template match="*" mode="wwmode:pagetemplate-copynodes">
  <xsl:variable name="VarNode" select="." />

  <xsl:element name="{local-name($VarNode)}" namespace="{namespace-uri($VarNode)}">
   <xsl:copy-of select="@*" />

   <xsl:apply-templates mode="wwmode:pagetemplate-copynodes" />
  </xsl:element>
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:pagetemplate-copynodes">
  <xsl:copy />
 </xsl:template>


 <!-- wwmode:pagetemplate-replacecontent -->
 <!--                                    -->

 <xsl:template match="*" mode="wwmode:pagetemplate-replacecontent">
  <xsl:param name="ParamContentName" />
  <xsl:param name="ParamReplacements" />

  <xsl:variable name="VarReplacement" select="$ParamReplacements/wwpage:Replacement[@name = $ParamContentName][1]" />
  <xsl:choose>
   <xsl:when test="count($VarReplacement) = 1">
    <xsl:choose>
     <xsl:when test="$VarReplacement/@value">
      <xsl:value-of select="$VarReplacement/@value" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:apply-templates select="$VarReplacement/node() | $VarReplacement/text() | $VarReplacement/comment() | $VarReplacement/processing-instruction()" mode="wwmode:pagetemplate-copynodes" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>

   <xsl:otherwise>
    <!-- Check for settings -->
    <!--                    -->
    <xsl:if test="starts-with($ParamContentName, 'wwsetting:')">
     <xsl:value-of select="wwprojext:GetFormatSetting(substring-after($ParamContentName, 'wwsetting:'))" />
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:pagetemplate-replacecontent">
  <!-- Nothing to do -->
  <!--               -->
 </xsl:template>


 <!-- wwmode:pagetemplate-replaceattribute -->
 <!--                                      -->

 <xsl:template match="wwpage:ActionAttribute[(@action = 'copy-relative-to-output') or (@action = 'relative-to-output')]" mode="wwmode:pagetemplate-replaceattribute">
  <xsl:param name="ParamActionAttribute" select="." />
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamReplacements" />
  <xsl:param name="ParamAttribute" />

  <!-- Relative path values -->
  <!--                      -->
  <xsl:variable name="VarAbsoluteOutputPath" select="wwfilesystem:Combine($ParamOutputDirectoryPath, $ParamAttribute)" />
  <xsl:variable name="VarRelativeOutputURI" select="wwuri:GetRelativeTo($VarAbsoluteOutputPath, $ParamOutputPath)" />

  <wwpage:Attribute name="{name($ParamAttribute)}" value="{$VarRelativeOutputURI}" />
 </xsl:template>


 <xsl:template match="wwpage:ActionAttribute[starts-with(@action, 'wwsetting:')]" mode="wwmode:pagetemplate-replaceattribute">
  <xsl:param name="ParamActionAttribute" select="." />
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamReplacements" />
  <xsl:param name="ParamAttribute" />

  <!-- Settings values -->
  <!--                 -->
  <wwpage:Attribute name="{name($ParamAttribute)}" value="{wwprojext:GetFormatSetting(substring-after($ParamActionAttribute/@action, 'wwsetting:'))}" />
 </xsl:template>


 <xsl:template match="wwpage:ActionAttribute" mode="wwmode:pagetemplate-replaceattribute">
  <xsl:param name="ParamActionAttribute" select="." />
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamReplacements" />
  <xsl:param name="ParamAttribute" />

  <!-- Replacement values -->
  <!--                    -->
  <xsl:variable name="VarReplacement" select="$ParamReplacements/wwpage:Replacement[@name = $ParamActionAttribute/@action][1]" />
  <xsl:if test="count($VarReplacement) = 1">
   <wwpage:Attribute name="{name($ParamAttribute)}">
    <xsl:attribute name="value">
     <xsl:choose>
      <xsl:when test="string-length($VarReplacement/@value) &gt; 0">
       <xsl:value-of select="$VarReplacement/@value" />
      </xsl:when>

      <xsl:otherwise>
       <xsl:for-each select="$VarReplacement/text()">
        <xsl:value-of select="normalize-space(.)" />
       </xsl:for-each>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:attribute>
   </wwpage:Attribute>
  </xsl:if>
 </xsl:template>


 <xsl:template match="*" mode="wwmode:pagetemplate-replaceattribute">
  <xsl:param name="ParamActionAttribute" select="." />
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamReplacements" />
  <xsl:param name="ParamAttribute" />

  <!-- Nothing to do -->
  <!--               -->
 </xsl:template>


 <xsl:template match="text() | comment() | processing-instruction()" mode="wwmode:pagetemplate-replaceattribute">
  <xsl:param name="ParamActionAttribute" select="." />
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamReplacements" />
  <xsl:param name="ParamAttribute" />

  <!-- Nothing to do -->
  <!--               -->
 </xsl:template>


 <xsl:template name="PageTemplate-ReplaceAttributes">
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamAttributes" />
  <xsl:param name="ParamReplacements" />

  <!-- Extract action attributes -->
  <!--                                -->
  <xsl:variable name="VarActionAttributesAsXML">
   <xsl:for-each select="$ParamAttributes[starts-with(name(), 'wwpage:attribute-')]">
    <xsl:variable name="VarAttribute" select="." />

    <wwpage:ActionAttribute name="{translate(substring-after(name($VarAttribute), 'wwpage:attribute-'), '-', ':')}" action="{$VarAttribute}" />
   </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="VarActionAttributes" select="msxsl:node-set($VarActionAttributesAsXML)" />

  <!-- Emit new attributes -->
  <!--                     -->
  <xsl:for-each select="$ParamAttributes[not(starts-with(name(), 'wwpage:attribute-'))]">
   <xsl:variable name="VarAttribute" select="." />

   <xsl:variable name="VarActionAttribute" select="$VarActionAttributes/wwpage:ActionAttribute[@name = name($VarAttribute)][1]" />
   <xsl:choose>
    <xsl:when test="count($VarActionAttribute) = 1">
     <!-- Determine replacement value -->
     <!--                             -->
     <xsl:apply-templates select="$VarActionAttribute" mode="wwmode:pagetemplate-replaceattribute">
      <xsl:with-param name="ParamOutputDirectoryPath" select="$ParamOutputDirectoryPath" />
      <xsl:with-param name="ParamOutputPath" select="$ParamOutputPath" />
      <xsl:with-param name="ParamReplacements" select="$ParamReplacements" />
      <xsl:with-param name="ParamAttribute" select="$VarAttribute" />
     </xsl:apply-templates>
    </xsl:when>

    <xsl:otherwise>
     <!-- Keep previous value -->
     <!--                     -->
     <wwpage:Attribute name="{name($VarAttribute)}" value="{$VarAttribute}" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>


 <!-- wwmode:pagetemplate -->
 <!--                     -->

 <xsl:template match="/" mode="wwmode:pagetemplate">
  <xsl:param name="ParamPageTemplateURI" select="''" />
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamConditions" />
  <xsl:param name="ParamReplacements" select="msxsl:node-set('')" />

  <xsl:apply-templates select="node() | text() | comment() | processing-instruction()" mode="wwmode:pagetemplate">
   <xsl:with-param name="ParamPageTemplateURI" select="$ParamPageTemplateURI" />
   <xsl:with-param name="ParamOutputDirectoryPath" select="$ParamOutputDirectoryPath" />
   <xsl:with-param name="ParamOutputPath" select="$ParamOutputPath" />
   <xsl:with-param name="ParamConditions" select="$ParamConditions" />
   <xsl:with-param name="ParamReplacements" select="$ParamReplacements" />
  </xsl:apply-templates>
 </xsl:template>


 <xsl:template match="*[(string-length(@wwpage:content) &gt; 0) or (string-length(@wwpage:replace) &gt; 0)] | wwpage:*[(string-length(@wwpage:content) &gt; 0) or (string-length(@wwpage:replace) &gt; 0)]" mode="wwmode:pagetemplate">
  <xsl:param name="ParamPageTemplateURI" select="''" />
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamConditions" />
  <xsl:param name="ParamReplacements" select="msxsl:node-set('')" />

  <xsl:variable name="VarNode" select="." />

  <!-- Evaluate condition -->
  <!--                    -->
  <xsl:for-each select="$ParamConditions[1]">
   <xsl:if test="(count($VarNode/@wwpage:condition) = 0) or (count(key('wwpage-conditions-by-name', $VarNode/@wwpage:condition)[1]) = 1)">
    <!-- Filter attributes -->
    <!--                   -->
    <xsl:variable name="VarAttributesAsXML">
     <xsl:call-template name="PageTemplate-ReplaceAttributes">
      <xsl:with-param name="ParamOutputDirectoryPath" select="$ParamOutputDirectoryPath" />
      <xsl:with-param name="ParamOutputPath" select="$ParamOutputPath" />
      <xsl:with-param name="ParamAttributes" select="$VarNode/@*[(name() != 'wwpage:content') and (name() != 'wwpage:replace') and (name() != 'wwpage:content-from-file') and (name() != 'wwpage:replace-from-file') and (name() != 'wwpage:condition')]" />
      <xsl:with-param name="ParamReplacements" select="$ParamReplacements" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarAttributes" select="msxsl:node-set($VarAttributesAsXML)" />

    <!-- Extend replacements with attribute values -->
    <!--                                           -->
    <xsl:variable name="VarReplacementsAsXML">
     <!-- Copy existing replacements -->
     <!--                            -->
     <xsl:for-each select="$ParamReplacements">
      <xsl:variable name="VarReplacement" select="." />

      <xsl:copy-of select="$VarReplacement" />
     </xsl:for-each>

     <!-- Add attribute replacements -->
     <!--                            -->
     <xsl:for-each select="$VarAttributes/wwpage:Attribute">
      <xsl:variable name="VarAttribute" select="." />

      <wwpage:Replacement name="wwattribute:{$VarAttribute/@name}" value="{$VarAttribute/@value}" />
     </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

    <!-- Handle wwpage:content or wwpage:replace -->
    <!--                                         -->
    <xsl:choose>
     <!-- wwpage:replace                                   -->
     <!-- Suppress emission of wwpage:* elements in result -->
     <!--                                                  -->
     <xsl:when test="(string-length($VarNode/@wwpage:replace) &gt; 0) or ((string-length($VarNode/@wwpage:content) &gt; 0) and (starts-with(name($VarNode), 'wwpage:')))">
      <xsl:apply-templates select="$VarNode" mode="wwmode:pagetemplate-replacecontent">
       <xsl:with-param name="ParamContentName" select="$VarNode/@wwpage:replace" />
       <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
      </xsl:apply-templates>
     </xsl:when>

     <!-- wwpage:content -->
     <!--                -->
     <xsl:otherwise>
      <!-- Copy element -->
      <!--              -->
      <xsl:element name="{local-name($VarNode)}" namespace="{namespace-uri($VarNode)}">
       <!-- Update attributes -->
       <!--                   -->
       <xsl:for-each select="$VarAttributes/wwpage:Attribute">
        <xsl:variable name="VarAttribute" select="." />

        <!-- Do not emit empty attribute values -->
        <!--                                    -->
        <xsl:if test="string-length($VarAttribute/@value) &gt; 0">
         <xsl:attribute name="{$VarAttribute/@name}">
          <xsl:value-of select="$VarAttribute/@value" />
         </xsl:attribute>
        </xsl:if>
       </xsl:for-each>

       <!-- Content -->
       <!--         -->
       <xsl:apply-templates select="$VarNode" mode="wwmode:pagetemplate-replacecontent">
        <xsl:with-param name="ParamContentName" select="$VarNode/@wwpage:content" />
        <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
       </xsl:apply-templates>
      </xsl:element>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>


 <xsl:template match="*[(string-length(@wwpage:content-from-file) &gt; 0) or (string-length(@wwpage:replace-from-file) &gt; 0)]" mode="wwmode:pagetemplate">
  <xsl:param name="ParamPageTemplateURI" select="''" />
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamConditions" />
  <xsl:param name="ParamReplacements" select="msxsl:node-set('')" />

  <xsl:variable name="VarNode" select="." />

  <!-- Page Template Directory URI -->
  <!--                             -->
  <xsl:variable name="VarPageTemplateDirectoryURI">
   <xsl:if test="string-length($ParamPageTemplateURI) &gt; 0">
    <xsl:value-of select="wwuri:MakeAbsolute($ParamPageTemplateURI, '..')" />
   </xsl:if>
  </xsl:variable>

  <!-- Evaluate condition -->
  <!--                    -->
  <xsl:for-each select="$ParamConditions[1]">
   <xsl:if test="(count($VarNode/@wwpage:condition) = 0) or (count(key('wwpage-conditions-by-name', $VarNode/@wwpage:condition)[1]) = 1)">
    <!-- Filter attributes -->
    <!--                   -->
    <xsl:variable name="VarAttributesAsXML">
     <xsl:call-template name="PageTemplate-ReplaceAttributes">
      <xsl:with-param name="ParamOutputDirectoryPath" select="$ParamOutputDirectoryPath" />
      <xsl:with-param name="ParamOutputPath" select="$ParamOutputPath" />
      <xsl:with-param name="ParamAttributes" select="$VarNode/@*[(name() != 'wwpage:content') and (name() != 'wwpage:replace') and (name() != 'wwpage:content-from-file') and (name() != 'wwpage:replace-from-file') and (name() != 'wwpage:condition')]" />
      <xsl:with-param name="ParamReplacements" select="$ParamReplacements" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarAttributes" select="msxsl:node-set($VarAttributesAsXML)" />

    <!-- Extend replacements with attribute values -->
    <!--                                           -->
    <xsl:variable name="VarReplacementsAsXML">
     <!-- Copy existing replacements -->
     <!--                            -->
     <xsl:for-each select="$ParamReplacements">
      <xsl:variable name="VarReplacement" select="." />

      <xsl:copy-of select="$VarReplacement" />
     </xsl:for-each>

     <!-- Add attribute replacements -->
     <!--                            -->
     <xsl:for-each select="$VarAttributes/wwpage:Attribute">
      <xsl:variable name="VarAttribute" select="." />

      <wwpage:Replacement name="wwattribute:{$VarAttribute/@name}" value="{$VarAttribute/@value}" />
     </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

    <!-- Handle wwpage:content-from-file or wwpage:replace-from-file -->
    <!--                                                             -->
    <xsl:choose>
     <!-- wwpage:replace-from-file                         -->
     <!--                                                  -->
     <xsl:when test="string-length($VarNode/@wwpage:replace-from-file) &gt; 0">
      <!-- Replace with file contents -->
      <!--                            -->
      <xsl:if test="string-length($VarPageTemplateDirectoryURI) &gt; 0">
       <xsl:variable name="VarFilePath" select="wwuri:AsFilePath(wwuri:MakeAbsolute($VarPageTemplateDirectoryURI, $VarNode/@wwpage:replace-from-file))" />
       <xsl:value-of select="wwstring:FromFile($VarFilePath, 'UTF-8')" />
      </xsl:if>
     </xsl:when>

     <!-- Suppress emission of wwpage:* elements in result -->
     <!-- wwpage:content-from-file                         -->
     <!--                                                  -->
     <xsl:when test="(string-length($VarNode/@wwpage:content-from-file) &gt; 0) and (starts-with(name($VarNode), 'wwpage:'))">
      <!-- Replace with file contents -->
      <!--                            -->
      <xsl:if test="string-length($VarPageTemplateDirectoryURI) &gt; 0">
       <xsl:variable name="VarFilePath" select="wwuri:AsFilePath(wwuri:MakeAbsolute($VarPageTemplateDirectoryURI, $VarNode/@wwpage:content-from-file))" />
       <xsl:value-of select="wwstring:FromFile($VarFilePath, 'UTF-8')" />
      </xsl:if>
     </xsl:when>

     <!-- wwpage:content-from-file -->
     <!--                          -->
     <xsl:otherwise>
      <!-- Copy element -->
      <!--              -->
      <xsl:element name="{local-name($VarNode)}" namespace="{namespace-uri($VarNode)}">
       <!-- Update attributes -->
       <!--                   -->
       <xsl:for-each select="$VarAttributes/wwpage:Attribute">
        <xsl:variable name="VarAttribute" select="." />

        <!-- Do not emit empty attribute values -->
        <!--                                    -->
        <xsl:if test="string-length($VarAttribute/@value) &gt; 0">
         <xsl:attribute name="{$VarAttribute/@name}">
          <xsl:value-of select="$VarAttribute/@value" />
         </xsl:attribute>
        </xsl:if>
       </xsl:for-each>

       <!-- Content -->
       <!--         -->
       <xsl:if test="string-length($VarPageTemplateDirectoryURI) &gt; 0">
        <xsl:variable name="VarFilePath" select="wwuri:AsFilePath(wwuri:MakeAbsolute($VarPageTemplateDirectoryURI, $VarNode/@wwpage:content-from-file))" />
        <xsl:value-of select="wwstring:FromFile($VarFilePath, 'UTF-8')" />
       </xsl:if>
      </xsl:element>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>


 <xsl:template match="wwpage:*" mode="wwmode:pagetemplate">
  <xsl:param name="ParamPageTemplateURI" select="''" />
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamConditions" />
  <xsl:param name="ParamReplacements" select="msxsl:node-set('')" />

  <xsl:variable name="VarNode" select="." />

  <!-- Evaluate condition -->
  <!--                    -->
  <xsl:for-each select="$ParamConditions[1]">
   <xsl:if test="(count($VarNode/@wwpage:condition) = 0) or (count(key('wwpage-conditions-by-name', $VarNode/@wwpage:condition)[1]) = 1)">
    <!-- Suppress emission of wwpage:* elements in result -->
    <!--                                                  -->

    <!-- Process children -->
    <!--                  -->
    <xsl:variable name="VarChildren" select="$VarNode/node() | $VarNode/text() | $VarNode/comment() | $VarNode/processing-instruction()" />
    <xsl:apply-templates select="$VarChildren" mode="wwmode:pagetemplate">
     <xsl:with-param name="ParamPageTemplateURI" select="$ParamPageTemplateURI" />
     <xsl:with-param name="ParamOutputDirectoryPath" select="$ParamOutputDirectoryPath" />
     <xsl:with-param name="ParamOutputPath" select="$ParamOutputPath" />
     <xsl:with-param name="ParamConditions" select="$ParamConditions" />
     <xsl:with-param name="ParamReplacements" select="$ParamReplacements" />
    </xsl:apply-templates>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>


 <xsl:template match="*" mode="wwmode:pagetemplate">
  <xsl:param name="ParamPageTemplateURI" select="''" />
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamConditions" />
  <xsl:param name="ParamReplacements" select="msxsl:node-set('')" />

  <xsl:variable name="VarNode" select="." />

  <!-- Evaluate condition -->
  <!--                    -->
  <xsl:for-each select="$ParamConditions[1]">
   <xsl:if test="(count($VarNode/@wwpage:condition) = 0) or (count(key('wwpage-conditions-by-name', $VarNode/@wwpage:condition)[1]) = 1)">
    <!-- Filter attributes -->
    <!--                   -->
    <xsl:variable name="VarAttributesAsXML">
     <xsl:call-template name="PageTemplate-ReplaceAttributes">
      <xsl:with-param name="ParamOutputDirectoryPath" select="$ParamOutputDirectoryPath" />
      <xsl:with-param name="ParamOutputPath" select="$ParamOutputPath" />
      <xsl:with-param name="ParamAttributes" select="$VarNode/@*[name() != 'wwpage:condition']" />
      <xsl:with-param name="ParamReplacements" select="$ParamReplacements" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarAttributes" select="msxsl:node-set($VarAttributesAsXML)" />

    <!-- Process -->
    <!--         -->
    <xsl:choose>
     <xsl:when test="$VarNode/node()[1] | $VarNode/text()[1] | $VarNode/comment()[1] | $VarNode/processing-instruction()[1]">
      <xsl:choose>
       <xsl:when test="count($VarNode/@wwpage:*[name() != 'wwpage:condition'][1]) = 1">
        <!-- Copy element -->
        <!--              -->
        <xsl:element name="{local-name($VarNode)}" namespace="{namespace-uri($VarNode)}">
         <xsl:for-each select="$VarAttributes/wwpage:Attribute">
          <xsl:variable name="VarAttribute" select="." />

          <!-- Do not emit empty attribute values -->
          <!--                                    -->
          <xsl:if test="string-length($VarAttribute/@value) &gt; 0">
           <xsl:attribute name="{$VarAttribute/@name}">
            <xsl:value-of select="$VarAttribute/@value" />
           </xsl:attribute>
          </xsl:if>
         </xsl:for-each>

         <!-- Process children -->
         <!--                  -->
         <xsl:variable name="VarChildren" select="$VarNode/node() | $VarNode/text() | $VarNode/comment() | $VarNode/processing-instruction()" />
         <xsl:apply-templates select="$VarChildren" mode="wwmode:pagetemplate">
          <xsl:with-param name="ParamPageTemplateURI" select="$ParamPageTemplateURI" />
          <xsl:with-param name="ParamOutputDirectoryPath" select="$ParamOutputDirectoryPath" />
          <xsl:with-param name="ParamOutputPath" select="$ParamOutputPath" />
          <xsl:with-param name="ParamConditions" select="$ParamConditions" />
          <xsl:with-param name="ParamReplacements" select="$ParamReplacements" />
         </xsl:apply-templates>
        </xsl:element>
       </xsl:when>

       <xsl:otherwise>
        <!-- Copy element -->
        <!--              -->
        <xsl:element name="{local-name($VarNode)}" namespace="{namespace-uri($VarNode)}">
         <xsl:copy-of select="$VarNode/@*[name() != 'wwpage:condition']" />

         <!-- Process children -->
         <!--                  -->
         <xsl:variable name="VarChildren" select="$VarNode/node() | $VarNode/text() | $VarNode/comment() | $VarNode/processing-instruction()" />
         <xsl:apply-templates select="$VarChildren" mode="wwmode:pagetemplate">
          <xsl:with-param name="ParamPageTemplateURI" select="$ParamPageTemplateURI" />
          <xsl:with-param name="ParamOutputDirectoryPath" select="$ParamOutputDirectoryPath" />
          <xsl:with-param name="ParamOutputPath" select="$ParamOutputPath" />
          <xsl:with-param name="ParamConditions" select="$ParamConditions" />
          <xsl:with-param name="ParamReplacements" select="$ParamReplacements" />
         </xsl:apply-templates>
        </xsl:element>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>

     <xsl:otherwise>
      <!-- Element has no children -->
      <!--                         -->
      <xsl:variable name="VarEmptyElementAsXML">
       <!-- Copy element -->
       <!--              -->
       <xsl:element name="{local-name($VarNode)}" namespace="{namespace-uri($VarNode)}">
        <xsl:for-each select="$VarAttributes/wwpage:Attribute">
         <xsl:variable name="VarAttribute" select="." />

         <!-- Do not emit empty attribute values -->
         <!--                                    -->
         <xsl:if test="string-length($VarAttribute/@value) &gt; 0">
          <xsl:attribute name="{$VarAttribute/@name}">
           <xsl:value-of select="$VarAttribute/@value" />
          </xsl:attribute>
         </xsl:if>
        </xsl:for-each>
       </xsl:element>
      </xsl:variable>
      <xsl:variable name="VarEmptyElement" select="msxsl:node-set($VarEmptyElementAsXML)/*[1]" />

      <!-- Emit element -->
      <!--              -->
      <xsl:copy-of select="$VarEmptyElement" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>


 <xsl:template match="text()" mode="wwmode:pagetemplate">
  <xsl:param name="ParamPageTemplateURI" select="''" />
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamConditions" />
  <xsl:param name="ParamReplacements" select="msxsl:node-set('')" />

  <xsl:copy />
 </xsl:template>


 <xsl:template match="comment()" mode="wwmode:pagetemplate">
  <xsl:param name="ParamPageTemplateURI" select="''" />
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamConditions" />
  <xsl:param name="ParamReplacements" select="msxsl:node-set('')" />

  <xsl:copy />
 </xsl:template>


 <xsl:template match="processing-instruction()" mode="wwmode:pagetemplate">
  <xsl:param name="ParamPageTemplateURI" select="''" />
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamOutputPath" />
  <xsl:param name="ParamConditions" />
  <xsl:param name="ParamReplacements" select="msxsl:node-set('')" />

  <xsl:copy />
 </xsl:template>
</xsl:stylesheet>
